/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.views;

import com.aptana.terminal.TerminalPlugin;
import com.aptana.terminal.Utils;
import com.aptana.terminal.internal.IProcessListener;
import com.aptana.terminal.views.Messages;
import com.aptana.terminal.widget.TerminalComposite;
import com.aptana.ui.keybinding.KeyBindingHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCut;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionSelectAll;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart
implements ISaveablePart2,
IProcessListener {
    public static final String ID = "com.aptana.terminal.views.terminal";
    private static final String PROP_TITLE = "title";
    private static final String PROP_WORKING_DIRECTORY = "workingDirectory";
    private TerminalComposite terminalComposite;
    private IMemento savedState = null;
    private Action fOpenEditorAction;
    private Action fOpenViewAction;
    private TerminalActionCopy fActionEditCopy;
    private TerminalActionCut fActionEditCut;
    private TerminalActionPaste fActionEditPaste;
    private TerminalActionClearAll fActionEditClearAll;
    private TerminalActionSelectAll fActionEditSelectAll;
    private boolean checkCanClose = false;

    public static TerminalView openView(String secondaryId, String title, IPath workingDirectory) {
        TerminalView view = null;
        secondaryId = secondaryId != null ? secondaryId : Long.toHexString(System.currentTimeMillis());
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            view = (TerminalView)page.showView(ID, secondaryId, 1);
            view.initialize(title, workingDirectory);
        }
        catch (PartInitException e) {
            TerminalPlugin.log("Terminal view creation failed.", e);
        }
        return view;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.savedState = memento;
    }

    public void createPartControl(Composite parent) {
        this.terminalComposite = new TerminalComposite(parent, 0);
        this.terminalComposite.setTerminalListener(new ITerminalListener(){

            public void setTerminalTitle(final String title) {
                Utils.runInDisplayThread(new Runnable(){

                    public void run() {
                        TerminalView.this.setPartName(title);
                    }
                });
            }

            public void setState(TerminalState state) {
            }
        });
        this.terminalComposite.setProcessListener(this);
        if (this.getViewSite().getSecondaryId() == null || this.savedState != null) {
            if (this.savedState != null) {
                this.loadState(this.savedState);
            }
            this.terminalComposite.connect();
        }
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.terminalComposite.getTerminalControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TerminalView.this.updateActions();
            }
        });
        this.terminalComposite.getTerminalControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.doit) {
                    Event event = new Event();
                    event.character = e.character;
                    event.keyCode = e.keyCode;
                    event.stateMask = e.stateMask;
                    event.doit = e.doit;
                    event.display = e.display;
                    event.widget = e.widget;
                    event.time = e.time;
                    event.data = e.data;
                    KeyBindingHelper.handleEvent((Event)event);
                }
            }
        });
        DropTarget dt = new DropTarget(this.terminalComposite.getRootControl(), 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType) && (fileList = (String[])event.data) != null && fileList.length > 0) {
                    StringBuilder builder = new StringBuilder();
                    String[] stringArray = fileList;
                    int n = fileList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        builder.append(file).append(' ');
                        ++n2;
                    }
                    TerminalView.this.terminalComposite.sendInput(builder.toString());
                }
            }
        });
    }

    protected void close() {
        if (this.terminalComposite != null && !this.terminalComposite.isDisposed()) {
            this.terminalComposite.getTerminalControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TerminalView.this.getSite().getPage().hideView((IViewPart)TerminalView.this.getSite().getPart());
                }
            });
        }
    }

    public void processCompleted() {
        IPreferenceStore prefs = TerminalPlugin.getDefault().getPreferenceStore();
        boolean closeViewOnExit = prefs.getBoolean("com.aptana.terminal.closeViewOnExit");
        if (closeViewOnExit) {
            this.close();
        }
    }

    public int promptToSaveOnClose() {
        return this.terminalComposite.canCloseTerminal() ? 0 : 2;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        try {
            boolean bl = this.checkCanClose;
            return bl;
        }
        finally {
            this.checkCanClose = false;
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        this.checkCanClose = true;
        return true;
    }

    public void saveState(IMemento memento) {
        IMemento child = memento.createChild(PROP_TITLE);
        child.putTextData(this.getPartName());
        child = memento.createChild(PROP_WORKING_DIRECTORY);
        IPath workingDirectory = this.terminalComposite.getWorkingDirectory();
        if (workingDirectory != null) {
            child.putTextData(workingDirectory.toOSString());
        }
    }

    private void loadState(IMemento memento) {
        String value;
        IMemento child = memento.getChild(PROP_TITLE);
        if (child != null) {
            this.setPartName(child.getTextData());
        }
        if ((child = memento.getChild(PROP_WORKING_DIRECTORY)) != null && (value = child.getTextData()) != null) {
            this.terminalComposite.setWorkingDirectory(Path.fromOSString((String)value));
        }
    }

    public void setFocus() {
        this.terminalComposite.setFocus();
    }

    protected void initialize(String title, IPath workingDirectory) {
        if (this.terminalComposite.isConnected()) {
            return;
        }
        this.setPartName(title);
        this.terminalComposite.setWorkingDirectory(workingDirectory);
        this.terminalComposite.connect();
    }

    public void sendInput(String text) {
        this.terminalComposite.sendInput(text);
    }

    public void clear() {
        this.terminalComposite.clear();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TerminalView.this.fillContextMenu(manager);
            }
        });
        Control control = this.terminalComposite.getTerminalControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        menuMgr.add((IAction)this.fActionEditCopy);
        menuMgr.add((IAction)this.fActionEditPaste);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fActionEditClearAll);
        menuMgr.add((IAction)this.fActionEditSelectAll);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.fOpenViewAction);
        menuMgr.add((IAction)this.fOpenEditorAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void contributeToActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(actionBars.getMenuManager());
        this.fillLocalToolBar(actionBars.getToolBarManager());
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fActionEditCopy);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fActionEditPaste);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fActionEditSelectAll);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fOpenViewAction);
        manager.add((IAction)this.fOpenEditorAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fOpenViewAction);
        manager.add((IAction)this.fOpenEditorAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fActionEditClearAll);
    }

    private void updateActions() {
        boolean aboutToShow = true;
        this.fActionEditCut.updateAction(aboutToShow);
        this.fActionEditCopy.updateAction(aboutToShow);
        this.fActionEditPaste.updateAction(aboutToShow);
        this.fActionEditSelectAll.updateAction(aboutToShow);
        this.fActionEditClearAll.updateAction(aboutToShow);
    }

    private void makeActions() {
        this.fActionEditCopy = new TerminalActionCopy(this.terminalComposite.getTerminalViewControl());
        this.fActionEditCut = new TerminalActionCut(this.terminalComposite.getTerminalViewControl());
        this.fActionEditPaste = new TerminalActionPaste(this.terminalComposite.getTerminalViewControl());
        this.fActionEditClearAll = new TerminalActionClearAll(this.terminalComposite.getTerminalViewControl()){

            public void run() {
                super.run();
                TerminalView.this.updateActions();
            }
        };
        this.fActionEditSelectAll = new TerminalActionSelectAll(this.terminalComposite.getTerminalViewControl()){

            public void run() {
                super.run();
                TerminalView.this.updateActions();
            }
        };
        this.fOpenViewAction = new Action(Messages.TerminalView_Open_Terminal_View, TerminalPlugin.getImageDescriptor("/icons/terminal_small_add.png")){

            public void run() {
                TerminalView.openView(null, TerminalView.this.getPartName(), TerminalView.this.getWorkingDirectory());
            }
        };
        this.fOpenViewAction.setToolTipText(Messages.TerminalView_Create_Terminal_View_Tooltip);
        this.fOpenEditorAction = new Action(Messages.TerminalView_Open_Terminal_Editor, TerminalPlugin.getImageDescriptor("/icons/terminal_add.png")){

            public void run() {
                Utils.openTerminalEditor("com.aptana.terminal.TerminalEditor", true);
            }
        };
        this.fOpenEditorAction.setToolTipText(Messages.TerminalView_Create_Terminal_Editor_Tooltip);
    }

    public IPath getWorkingDirectory() {
        return this.terminalComposite.getWorkingDirectory();
    }
}

